@extends('layouts.app')

@section('main')
    <div class="container-fluid">
        <div class="row">
            <div class="col-12">
                <div class="card">
                    <div class="card-header">
                        <h3 class="card-title">Edit Subscription</h3>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('subscriptions.update', $subscription) }}" method="POST">
                            @csrf
                            @method('PUT')
                            <div class="form-group">
                                <label for="plan_id">Plan</label>
                                <select class="form-control" id="plan_id" name="plan_id" required>
                                    @foreach (\App\Models\Plan::where('is_active', true)->get() as $plan)
                                        <option value="{{ $plan->id }}"
                                            {{ $subscription->plan_id == $plan->id ? 'selected' : '' }}>{{ $plan->name }}
                                            - ${{ $plan->price }}/{{ $plan->interval }}</option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <label for="start_date">Start Date</label>
                                <input type="date" class="form-control" id="start_date" name="start_date"
                                    value="{{ $subscription->start_date ? \Carbon\Carbon::parse($subscription->start_date)->format('Y-m-d') : '' }}"
                                    required>
                            </div>
                            <div class="form-group">
                                <label for="end_date">End Date</label>
                                <input type="date" class="form-control" id="end_date" name="end_date"
                                    value="{{ $subscription->end_date ? \Carbon\Carbon::parse($subscription->end_date)->format('Y-m-d') : '' }}">
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" id="status" name="status" required>
                                    <option value="active" {{ $subscription->status == 'active' ? 'selected' : '' }}>Active
                                    </option>
                                    <option value="cancelled" {{ $subscription->status == 'cancelled' ? 'selected' : '' }}>
                                        Cancelled</option>
                                    <option value="expired" {{ $subscription->status == 'expired' ? 'selected' : '' }}>
                                        Expired</option>
                                </select>
                            </div>
                            <button type="submit" class="btn btn-primary">Update</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
